package com.bytesbee.mysinglelivechannel.api;

import com.bytesbee.mysinglelivechannel.callbacks.CallbackChannel;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackSettings;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackUser;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Query;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public interface ApiInterface {

    String CACHE = "Cache-Control: max-age=0";
    String AGENT = "Data-Agent: Single TV";

    // ============= Login =============
    @Headers({CACHE, AGENT})
    @GET("api/login/")
    Call<CallbackUser> login(@Query("api_key") String api_key, @Query("username") String username, @Query("password") String password, @Query("device_type") String device_type);

    @Headers({CACHE, AGENT})
    @GET("api/register/")
    Call<CallbackUser> register(@Query("api_key") String api_key, @Query("username") String username, @Query("password") String password, @Query("email") String email);

    @Headers({CACHE, AGENT})
    @GET("api/changePassword/")
    Call<CallbackUser> changePassword(@Query("api_key") String api_key, @Query("username") String username, @Query("email") String email, @Query("old_password") String old_password, @Query("new_password") String new_password);

    // ============= Channel =============
    @Headers({CACHE, AGENT})
    @GET("api/getSingleChannel/")
    Call<CallbackChannel> getSingleChannel(@Query("api_key") String api_key);

    @Headers({CACHE, AGENT})
    @GET("api/insertLinkCount/")
    Call<CallbackUser> insertLinkCount(@Query("api_key") String api_key, @Query("link1_name") int link1_name, @Query("link2_name") int link2_name, @Query("channel_type") String channel_type);

    // ============= Settings =============
    @Headers({CACHE, AGENT})
    @GET("api/getAppSettings/")
    Call<CallbackSettings> getSettings(@Query("api_key") String api_key);

}
